require( "quest/m3_ship/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talke",
	"anim/flo/talkw",
	"anim/flo/walke",
	"anim/flo/walkw",
};

flo_spec =
{
	name = "FLO"; point_at_name = "obj_flo";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		----actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:JumpToNamedPoint("flo");
		actor:Face(DIR.E);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:SetMode(MODE.FOLLOWCLICKS);
		
		game:EarnAward("avenue-flo_finish");
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		--sfx:SetMusic("audio/music/office.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end
	end;
};

scene_spec =
{
	--atlas = 
	--{
	--	"pieces" -- load pieces
	--};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		scene_setup,
	};
};
